<?php
/* --------------------------------------------------------------
   LanguageCriteria.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\SqlCriteria;

use Gambio\Core\Criteria\AbstractSqlCriteria;

/**
 * Class LanguageRestApiCriteria
 *
 * @package Gambio\Core\Language\SqlCriteria
 */
class LanguageSqlCriteria extends AbstractSqlCriteria implements \Gambio\Core\Language\LanguageSqlCriteria
{
    /**
     * LanguageSqlCriteria constructor.
     *
     * @param LanguageFilters  $filters
     * @param LanguageSortings $sortings
     */
    private function __construct(LanguageFilters $filters, LanguageSortings $sortings)
    {
        $this->filters  = $filters;
        $this->sortings = $sortings;
    }
    
    
    /**
     * @param LanguageFilters  $filters
     * @param LanguageSortings $sortings
     *
     * @return LanguageSqlCriteria
     */
    public static function create(LanguageFilters $filters, LanguageSortings $sortings): LanguageSqlCriteria
    {
        return new self($filters, $sortings);
    }
}